/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.event;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import javax.swing.event.EventListenerList;

public class VWPropertyChangeEventNotifier {
    private EventListenerList m_propertyChangeListeners = null;

    public void addPropertyChangeListener(IVWPropertyChangeListener listener) {
        if (this.m_propertyChangeListeners == null) {
            this.m_propertyChangeListeners = new EventListenerList();
        }
        this.removePropertyChangeListener(listener);
        this.m_propertyChangeListeners.add(IVWPropertyChangeListener.class, listener);
    }

    public void removePropertyChangeListener(IVWPropertyChangeListener listener) {
        if (this.m_propertyChangeListeners != null) {
            this.m_propertyChangeListeners.remove(IVWPropertyChangeListener.class, listener);
        }
    }

    public void notifyPropertyChange(IVWPropertyChangeSource source, int nId) {
        try {
            if (this.m_propertyChangeListeners != null && this.m_propertyChangeListeners.getListenerCount() > 0) {
                VWPropertyChangeEvent event = new VWPropertyChangeEvent(source, nId);
                Object[] listeners = this.m_propertyChangeListeners.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != IVWPropertyChangeListener.class) continue;
                    ((IVWPropertyChangeListener)listeners[i + 1]).propertyChange(event);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_propertyChangeListeners = null;
    }
}

